% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box.chron.R
\name{box.chron}
\alias{box.chron}
\title{Boxplots for simulation output.}
\usage{
box.chron(results, field.list = NULL, col.list = c("darkred", "darkgreen",
  "blue", "grey", "goldenrod"), opacity = 255, ylim = NULL,
  small.n = NULL, small.n.op = 126, add = FALSE, ...)
}
\arguments{
\item{results}{A list resembling the output from date.simulate or a related function, or a data table resembling the first component
thereof - i.e. the full simulation results.}

\item{field.list}{A character vector of columns in 'results' to be plotted. Defaults to NULL, in which case all suitable
columns in 'results' are used. Nb. variables entitled "catch" or "effort" will be ignored, due to their roles in output from
cpue.}

\item{col.list}{Character vector: colours to be used for each column plotted. Defaults to c("darkred", "darkgreen", "blue", "grey",
"goldenrod"). Nb. if more than five columns are plotted then the default colours will start to recycle.}

\item{opacity}{Numeric: opacity of each box. Defaults to  255, i.e. fully opaque.}

\item{ylim}{Numeric: an easy way to override the built-in scaling in plot - if a vector of length 1 is passed it will
be converted into c(0, ylim) to be passed to the ylim argument in plot. Alternatively a vector of length 2 will be passed
straight to plot as is. Defaults to NULL, in which case the built-in scaling in plot takes over.}

\item{small.n}{Character vector of colours to be used for boxes marking periods of low "effort", when plotting cpue results. Has no
effect if 'results' doesn't have a third element called "small.n". Defaults to NULL, in which case no boxes are plotted.}

\item{small.n.op}{Numeric vector of length equal to 'small.n' (or otherwise recycled to that length) specifying opacity for small.n
boxes. Defaults to 126 (i.e. ~50pc).}

\item{add}{Logical: should data be added to current plot, or should axis.setup be called to start a new plot? Defaults to FALSE.}

\item{...}{Other graphical arguments to be passed to plot. Nb. (a) includes special arguments for axis.setup (currently just 'lab.sp'),
(b) 'ylab' will default to "Estimated frequency density", as per axis.setup, unless specified here.}
}
\value{
None.
}
\description{
Plots a series of boxplots (one per bin) summarising the output from date.simulate or an associated function.
}
\examples{
date.ranges <- data.table(ID=c(1, 2, 3, 4), Start=c(450, 450, 600, 900), End=c(700, 800, 650, 1200))
x <- freq.simulate(date.ranges, weight=date.ranges$frags, bin.width=50, reps=200, summ=FALSE)
box.chron(x, field.list="count")
}

